/* Install STORET Warehouse database changes requried for WQX ETL 
  File : install_wh_db_changes.sql
  Note: modify the following before running this script.
     1) Grant create session privilege to storetw schema.
     2) Update define statements with schema names, passwords and database connect string. Schema NAMES are currently the same as in VDD.
     

Note:  Create STORETW_ETL schema and grant create session and create synonym privileges.  This schema will be used by Informatica ETL login to write or modify the warehouse tables.

Assumption:  STORET Warehouse version 2.0.6 is installed and functional.
Important:  If STORET Warehouse version is 2.0.5, upgrade to 2.0.6 can be achieved by running the wh_c206_ddl_and_new_attr.sql script as STORETW (Warehouse schema) and then applying install_wh_db_changes.sql on the STORET Warehouse.  This will create required tables and sequences to upgrade the version to 2.0.6 to make it ready for WQX_ETL

Note:  The following scripts have updates to Metadata tables in warehouse that are expected to be in production by 01/31/2007 (WQX production date).  Meanwhile, errors related to md_% object does not exist can be ignored.
*/

set define on
SET VERIFY ON
-- following variable are moved to c20-installation.sql file
/*
define DBA_ACCOUNT=SYSTEM
define DBA_ACCOUNT_PASS=SYSTEM

define WH_DB_CONNECTSTRING=STORMOD.SHIRE
--define WH_DB_CONNECTSTRING=epad9

define WH_SCHEMA=STORETW
define WH_SCHEMA_PASS=STORETW

define WH_ETL_SCHEMA=STORETW_ETL
define WH_ETL_SCHEMA_PASS=STORETW_ETL

define WH_ETL_ROLE=STORETW_ETL_ROLE

----END OF Editing Section -------
*/
--connect as dba account and grant required privileges
connect &DBA_ACCOUNT/&DBA_ACCOUNT_PASS@&WH_DB_CONNECTSTRING
spool install_wh_db_changes.log
set define on
SET VERIFY ON

create user &WH_ETL_SCHEMA IDENTIFIED BY &WH_ETL_SCHEMA_PASS
DEFAULT TABLESPACE USER_data
QUOTA 5 M ON USER_data;

create role &WH_ETL_ROLE;

grant create session to &WH_SCHEMA;
grant create session, CREATE SYNONYM to &WH_ETL_SCHEMA;

grant &WH_ETL_ROLE to &WH_ETL_SCHEMA;

spool off
-- STORET Warehouse database changes
-- connect as Warehouse schema (storetw)
connect &WH_SCHEMA/&WH_SCHEMA_PASS@&WH_DB_CONNECTSTRING
set define on
SET VERIFY ON

--@wh_c206_ddl_and_new_attr.sql

@C:\storetw\WQX_ETL\wh_mod_attr.sql
@C:\storetw\WQX_ETL\wh_new_attr.sql
@C:\storetw\WQX_ETL\wh_new_obj.sql

@C:\storetw\WQX_ETL\MT_char_chartype.sql
set define on;
@C:\storetw\WQX_ETL\SP_REFRESH_STATION_CHAR.sql
@C:\storetw\WQX_ETL\SP_REFRESH_STATION_CHAR_NEW.SQL

@C:\storetw\WQX_ETL\SP_REFRESH_WS_STATION_DATA.SQL

@C:\storetw\WQX_ETL\SP_REFRESH_WS_HUC_CHAR_SUMMARY.SQL
@C:\storetw\WQX_ETL\SP_REFRESH_WS_HUC_ORG_SUMMARY.SQL
@C:\storetw\WQX_ETL\SP_REFRESH_WS_ORG_CHAR_SUMMARY.SQL
@C:\storetw\WQX_ETL\SP_REFRESH_WS_STATION_SUMMARY.SQL

@C:\storetw\WQX_ETL\SP_REFRESH_WS_TABLES.sql
@C:\storetw\WQX_ETL\SP_REFRESH_WS_TABLES_NEW.SQL

@C:\storetw\WQX_ETL\SP_RUN_WATERSHED_TAB_REFRESH.SQL
@C:\storetw\WQX_ETL\sp_sequence_synch.sql

@C:\storetw\WQX_ETL\wh_grants.sql
disconnect;

-- create WH_ETL synonyms
connect &WH_ETL_SCHEMA/&WH_ETL_SCHEMA_PASS@&WH_DB_CONNECTSTRING
set define on
SET VERIFY ON

@C:\storetw\WQX_ETL\WH_etl_synonyms.sql
disconnect;
